/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.boxboard.groupman;

import org.apache.batik.dom.svg.SVGOMPoint;
import org.apache.batik.dom.svg.SVGOMRect;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGLocatable;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGRect;
import ru.infor.boxboard.groupman.Rect;

public class BlockPart {
    public Element el = null;
    public double x;
    public double y;
    public double width;
    public double height;
    public double angle;
    public double xc;
    public double yc;
    public int id = -1;

    public BlockPart(Element el, double x, double y, double width, double height) {
        this.el = el;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.angle = 0.0;
        this.xc = 0.0;
        this.yc = 0.0;
    }

    public BlockPart(Element el, double x, double y, double width, double height, int id) {
        this(el, x, y, width, height);
        this.id = id;
    }

    public double getMinX() {
        double res = 0.0;
        SVGRect r = ((SVGLocatable)((Object)this.el)).getBBox();
        if (this.angle == 90.0) {
            res = (r.getHeight() - r.getWidth()) / 2.0f + 5.0f;
        }
        if (this.angle == 270.0) {
            res = (r.getHeight() - r.getWidth()) / 2.0f - 5.0f;
        }
        return res;
    }

    public double getMinY() {
        double res = 0.0;
        if (this.angle == 90.0) {
            res = (this.width - this.height) / 2.0 + 10.0;
        }
        if (this.angle == 270.0) {
            res = (this.width - this.height) / 2.0 - 1.0;
        }
        return res;
    }

    public double getMaxX(double pageWidth) {
        double res = pageWidth - this.width;
        if (this.angle == 90.0) {
            res -= (this.height - this.width) / 2.0;
        }
        if (this.angle == 270.0) {
            res -= (this.height - this.width) / 2.0 + 11.0;
        }
        return res;
    }

    public double getMaxY(double pageHeight) {
        double res = pageHeight - this.height;
        if (this.angle == 90.0) {
            res -= (this.width - this.height) / 2.0 - 10.0;
        }
        if (this.angle == 180.0) {
            res -= 1.0;
        }
        if (this.angle == 270.0) {
            res -= (this.width - this.height) / 2.0 + 1.0;
        }
        return res;
    }

    public void correctPlacement(double maxW, double maxH) {
        this.x = this.x >= this.getMinX() ? this.x : this.getMinX();
        this.y = this.y >= this.getMinY() ? this.y : this.getMinY();
        this.x = this.x <= this.getMaxX(maxW) ? this.x : this.getMaxX(maxW);
        this.y = this.y <= this.getMaxY(maxH) ? this.y : this.getMaxY(maxH);
    }

    public Rect getTransformedRect() {
        SVGRect rect = ((SVGLocatable)((Object)this.el)).getBBox();
        SVGOMRect rect1 = new SVGOMRect((float)this.x, (float)this.y, (float)this.width, (float)this.height);
        double px = 0.0;
        double py = 0.0;
        double pw = rect.getWidth();
        double ph = rect.getHeight();
        if (this.angle == 0.0) {
            px = rect.getX();
            py = rect.getY();
        }
        if (this.angle == 90.0) {
            px = rect.getX();
            py = rect.getY() + rect.getHeight();
            pw = rect.getHeight();
            ph = rect.getWidth();
        }
        if (this.angle == 180.0) {
            px = rect.getX() + rect.getWidth();
            py = rect.getY() + rect.getHeight();
        }
        if (this.angle == 270.0) {
            px = rect.getX() + rect.getWidth();
            py = rect.getY();
            pw = rect.getHeight();
            ph = rect.getWidth();
        }
        SVGOMPoint pt = new SVGOMPoint((float)px, (float)py);
        SVGMatrix mat = ((SVGLocatable)((Object)this.el)).getCTM();
        SVGOMPoint ptNew = (SVGOMPoint)pt.matrixTransform(mat);
        return new Rect(ptNew.getX(), ptNew.getY(), pw, ph);
    }
}

