/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.boxboard.groupman;

import java.util.Vector;
import org.apache.batik.dom.svg.SVGOMPoint;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLocatable;
import org.w3c.dom.svg.SVGPathElement;
import org.w3c.dom.svg.SVGRect;
import ru.infor.boxboard.ModelPlacer;
import ru.infor.boxboard.groupman.BlockPart;
import ru.infor.boxboard.groupman.OnDownAction;
import ru.infor.boxboard.groupman.OnMoveAction;
import ru.infor.boxboard.groupman.OnUpAction;
import ru.infor.boxboard.groupman.Rect;
import ru.infor.navy.util.SVGTools;

public class GroupManager {
    public int drag;
    protected Element selectedItem;
    public SVGOMPoint initialDragPoint;
    public final int DRAG_UP = 0;
    public final int DRAG_DOWN = 1;
    Vector<BlockPart> modelBlock = new Vector();
    Element blockPart = null;
    SVGRect rectBlockPart = null;
    double blockPartLength = 0.0;
    ModelPlacer mp = null;
    int selected = -1;
    Element moveGroup = null;
    Element stillGroup = null;

    public GroupManager(ModelPlacer mp) {
        this.mp = mp;
    }

    public Element addEtalon(Document doc, double x, double y, double angle) {
        return this.addEtalon(doc, x, y, angle, true, -2);
    }

    public Element addEtalon(Document doc, double x, double y, double angle, boolean addToModelBlock, int bpid) {
        String r;
        Element svgRoot = doc.getDocumentElement();
        String svgNS = "http://www.w3.org/2000/svg";
        Element g = doc.createElementNS(svgNS, "g");
        String string = r = angle != 0.0 ? "rotate(" + Double.valueOf(angle).toString() + ")" : "";
        if (addToModelBlock) {
            BlockPart bp = new BlockPart(g, x, y, this.rectBlockPart.getWidth(), this.rectBlockPart.getHeight(), this.getNewBlockID());
            bpid = bp.id;
            this.addToModelList(bp);
        }
        g.setAttributeNS(null, "bpID", Integer.valueOf(bpid).toString());
        g.setAttributeNS(null, "transform", String.valueOf(r) + "translate(" + x + "," + y + ")");
        this.registerMoveListeners(g);
        this.stillGroup.appendChild(g);
        this.addMover(doc, g);
        NodeList nl = this.blockPart.getElementsByTagName("path");
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i) instanceof SVGElement) {
                SVGPathElement els = (SVGPathElement)nl.item(i);
                Element elt = doc.createElementNS(svgNS, "path");
                SVGTools.copyAttr(els, elt);
                g.appendChild(elt);
            }
            ++i;
        }
        return g;
    }

    private void addToModelList(BlockPart bp) {
        this.modelBlock.add(bp);
        this.correctCoeff(this.modelBlock.size() - 1);
    }

    public void addMoveGroups(Document doc) {
        Element svgRoot = doc.getDocumentElement();
        String svgNS = "http://www.w3.org/2000/svg";
        this.moveGroup = doc.createElementNS(svgNS, "g");
        this.stillGroup = doc.createElementNS(svgNS, "g");
        svgRoot.appendChild(this.stillGroup);
        svgRoot.appendChild(this.moveGroup);
    }

    private void addMover(Document doc, Element el) {
        Element rect = SVGTools.createRect(doc, this.rectBlockPart.getX(), this.rectBlockPart.getY(), this.rectBlockPart.getWidth(), this.rectBlockPart.getHeight(), "none", "blue", 1.0, 0, "display:none");
        rect.setAttributeNS(null, "nosave", "true");
        el.appendChild(rect);
        rect = SVGTools.createRect(doc, this.rectBlockPart.getX(), this.rectBlockPart.getY(), this.rectBlockPart.getWidth(), this.rectBlockPart.getHeight(), "blue", "none", 0.0, 0, "display:none");
        rect.setAttributeNS(null, "nosave", "true");
        el.appendChild(rect);
        el.appendChild(this.createRotateCorner(doc));
    }

    private Element createRotateCorner(Document doc) {
        Element g = SVGTools.createGroup(doc, "rotateCorner", "display: none;");
        g.setAttributeNS(null, "nosave", "true");
        g.setAttributeNS(null, "transform", "translate(40,29) scale(3)");
        g.appendChild(SVGTools.createRect(doc, 0.0, 0.053, 23.49, 19.949, "#ffffff", "#ffffff", 1.0, 0, ""));
        Element arrow = SVGTools.createPath(doc, "M6.197,19.607H0.5V3.964h10.63l0.008-3.121L22.229,6.93l-11.101,5.982 l0.009-2.977H6.197V19.607z", "#1D59A6", "#F6F6F5", 1.0, 255, "");
        arrow.setAttributeNS(null, "nosave", "true");
        g.appendChild(arrow);
        return g;
    }

    public void setRotateCornerTransform(Element el, BlockPart bp) {
        String trans = "";
        String rotate = "";
        double x = 40.0;
        double y = 29.0;
        Rect bpr = bp.getTransformedRect();
        SVGRect rect = ((SVGLocatable)((Object)el)).getBBox();
        if (bp.angle == 90.0) {
            x = 29.0;
            y = 60.0 + bp.height;
            rotate = " rotate(-90)";
        }
        if (bp.angle == 180.0) {
            x = 60.0 + bp.width;
            y = 71.0 + bp.height;
            rotate = " rotate(-180)";
        }
        if (bp.angle == 270.0) {
            x = 72.0 + bp.width;
            y = 40.0;
            rotate = " rotate(-270)";
        }
        trans = String.valueOf(x) + "," + y;
        el.setAttributeNS(null, "transform", "translate(" + trans + ") scale(3)" + rotate);
    }

    public void correctCoeff(int index) {
        if (index > 0) {
            BlockPart bp = this.modelBlock.elementAt(index);
            BlockPart bpPrev = this.modelBlock.elementAt(index - 1);
            bp.xc = bp.x / bpPrev.width;
            bp.yc = bp.y / bpPrev.height;
        }
    }

    public void changeBlockPart(Document doc, Element model, double length) {
        SVGRect rect;
        this.selected = -1;
        if (this.blockPart != null) {
            SVGTools.removeElement(this.blockPart);
        }
        this.blockPart = model;
        this.blockPartLength = length;
        this.rectBlockPart = rect = ((SVGLocatable)((Object)model)).getBBox();
        int i = 0;
        while (i < this.modelBlock.size()) {
            BlockPart bp = this.modelBlock.elementAt(i);
            SVGTools.removeElement(bp.el);
            bp.width = rect.getWidth();
            bp.height = rect.getHeight();
            if (i > 0) {
                BlockPart bpPrev = this.modelBlock.elementAt(i - 1);
                bp.x = bp.xc * (double)rect.getWidth();
                bp.y = bp.yc * (double)rect.getHeight();
            }
            bp.el = this.addEtalon(doc, bp.x, bp.y, 0.0, false, bp.id);
            this.setTransform(bp);
            ++i;
        }
    }

    public void clear() {
        for (BlockPart bp : this.modelBlock) {
            SVGTools.removeElement(bp.el);
        }
        this.modelBlock.removeAllElements();
    }

    public void deleteSelected() {
        if (this.selected < 0) {
            return;
        }
        SVGTools.removeElement(this.modelBlock.elementAt((int)this.selected).el);
        this.modelBlock.remove(this.selected);
        this.selected = -1;
    }

    public BlockPart getBlockPartByID(int id) {
        int index = this.getBlockPartIndexByID(id);
        if (index > -1) {
            return this.getBlockPartByIndex(index);
        }
        return null;
    }

    public BlockPart getBlockPartByIndex(int index) {
        return this.modelBlock.elementAt(index);
    }

    public int getBlockPartIndexByID(int id) {
        int res = -1;
        int i = 0;
        while (i < this.modelBlock.size()) {
            if (this.modelBlock.elementAt((int)i).id == id) {
                res = i;
                break;
            }
            ++i;
        }
        return res;
    }

    public Element getCombinedModel(Document doc) {
        Element svgRoot = doc.getDocumentElement();
        String svgNS = "http://www.w3.org/2000/svg";
        Element g = doc.createElementNS(svgNS, "g");
        Element g1 = doc.createElementNS(svgNS, "g");
        g.appendChild(g1);
        for (BlockPart bp : this.modelBlock) {
            Element g2 = doc.createElementNS(svgNS, "g");
            g2.setAttributeNS(null, "transform", bp.el.getAttribute("transform"));
            g1.appendChild(g2);
            NodeList nl = bp.el.getElementsByTagName("path");
            int i = 0;
            while (i < nl.getLength()) {
                if (nl.item(i) instanceof SVGElement && ((Element)nl.item(i)).getAttributeNS(null, "nosave").compareTo("true") != 0) {
                    Element els = (Element)nl.item(i);
                    Element elt = doc.createElementNS(svgNS, "path");
                    SVGTools.copyAttr(els, elt);
                    g2.appendChild(elt);
                }
                ++i;
            }
        }
        svgRoot.appendChild(g);
        return g;
    }

    public double getModelLength() {
        return this.blockPartLength * (double)this.modelBlock.size();
    }

    private int getNewBlockID() {
        int res = -1;
        for (BlockPart bp : this.modelBlock) {
            int n = res = bp.id > res ? bp.id : res;
        }
        return res + 1;
    }

    public int getSize() {
        return this.modelBlock.size();
    }

    public void moveSelected(double dx, double dy) {
        if (this.selected < 0) {
            return;
        }
        BlockPart bp = this.modelBlock.elementAt(this.selected);
        if (bp.angle == 0.0) {
            bp.x += dx;
            bp.y += dy;
        }
        if (bp.angle == 90.0) {
            bp.x -= dy;
            bp.y += dx;
        }
        if (bp.angle == 180.0) {
            bp.x -= dx;
            bp.y -= dy;
        }
        if (bp.angle == 270.0) {
            bp.x += dy;
            bp.y -= dx;
        }
        this.setTransform(bp);
    }

    public void directMoveSelected(double dx, double dy) {
        if (this.selected < 0) {
            return;
        }
        BlockPart bp = this.modelBlock.elementAt(this.selected);
        bp.x += dx;
        bp.y += dy;
        this.setTransform(bp);
    }

    public void registerMoveListeners(Element elt) {
        EventTarget t = (EventTarget)((Object)elt);
        t.addEventListener("mousedown", new OnDownAction(this), false);
        t.addEventListener("mousemove", new OnMoveAction(this), false);
        t.addEventListener("mouseup", new OnUpAction(this), false);
    }

    public void setBlockPart(Element model, double length) {
        SVGRect rect;
        this.selected = -1;
        if (this.blockPart != null) {
            SVGTools.removeElement(this.blockPart);
        }
        this.clear();
        this.blockPart = model;
        this.blockPartLength = length;
        this.rectBlockPart = rect = ((SVGLocatable)((Object)model)).getBBox();
    }

    private Element getRotateCorner(Element el) {
        NodeList nl = el.getElementsByTagName("g");
        Element rc = null;
        int i = 0;
        while (i < nl.getLength()) {
            Element e = (Element)nl.item(i);
            if (e.getAttribute("id").compareTo("rotateCorner") == 0) {
                rc = e;
                break;
            }
            ++i;
        }
        return rc;
    }

    private void rcSetVisible(Element el, boolean visible) {
        Element rc = this.getRotateCorner(el);
        if (rc != null) {
            rc.setAttributeNS(null, "style", visible ? "display:inline;" : "display:none;");
        }
    }

    public void setSelected(Element el) {
        Element el1;
        if (this.selected > -1) {
            Element oldSel = this.modelBlock.elementAt((int)this.selected).el;
            el1 = (Element)oldSel.getElementsByTagName("rect").item(0);
            el1.setAttributeNS(null, "style", "fill:none; stroke:#ffcc00; stroke-width:2; display:none;");
            this.rcSetVisible(oldSel, false);
            this.moveGroup.removeChild(oldSel);
            this.stillGroup.appendChild(oldSel);
        }
        this.selected = -1;
        int i = 0;
        while (i < this.modelBlock.size()) {
            if (this.modelBlock.elementAt((int)i).el == el) {
                this.selected = i;
                break;
            }
            ++i;
        }
        if (this.selected > -1) {
            Element sel = this.modelBlock.elementAt((int)this.selected).el;
            el1 = (Element)sel.getElementsByTagName("rect").item(0);
            el1.setAttributeNS(null, "style", "fill:none; stroke:#72B649; stroke-width:2; stroke-dasharray:8; display:inline;");
            this.rcSetVisible(sel, true);
            this.stillGroup.removeChild(sel);
            this.moveGroup.appendChild(sel);
        }
    }

    public void setSelectedAngle(double angle) {
        if (this.selected > -1) {
            BlockPart bp = this.modelBlock.elementAt(this.selected);
            bp.angle = angle;
            this.setTransform(bp);
            Element rc = this.getRotateCorner(bp.el);
            if (rc != null) {
                this.setRotateCornerTransform(rc, bp);
            }
        }
    }

    public Rect getBlockRect() {
        Rect res = new Rect(1000000.0, 1000000.0, 0.0, 0.0);
        for (BlockPart bp : this.modelBlock) {
            Rect r = bp.getTransformedRect();
            res.x = res.x > r.x ? r.x : res.x;
            res.y = res.y > r.y ? r.y : res.y;
            res.width = res.width < r.x + r.width ? r.x + r.width : res.width;
            double d = res.height = res.height < r.y + r.height ? r.y + r.height : res.height;
        }
        res.width -= res.x;
        res.height -= res.y;
        return res;
    }

    public void setTransform(BlockPart bp) {
        bp.correctPlacement(this.mp.getPageWidth(), this.mp.getPageHeight());
        SVGLocatable svgLoc = (SVGLocatable)((Object)bp.el);
        SVGRect rect = svgLoc.getBBox();
        double xc = 45.0f + rect.getWidth() / 2.0f;
        double yc = 40.0f + rect.getHeight() / 2.0f;
        String r = bp.angle != 0.0 ? " rotate(" + Double.valueOf(bp.angle).toString() + "," + xc + "," + yc + ") " : "";
        bp.el.setAttributeNS(null, "transform", "translate(" + bp.x + "," + bp.y + ")" + r);
    }

    public void addTransRect(Rect r) {
        SVGDocument doc = this.mp.canvas.getSVGDocument();
        Element svgRoot = doc.getDocumentElement();
        String svgNS = "http://www.w3.org/2000/svg";
        Element line = doc.createElementNS(svgNS, "rect");
        line.setAttributeNS(null, "fill", "none");
        line.setAttributeNS(null, "stroke", "#ff0080");
        line.setAttributeNS(null, "stroke-width", "0.1");
        line.setAttributeNS(null, "x", Double.valueOf(r.x).toString());
        line.setAttributeNS(null, "y", Double.valueOf(r.y).toString());
        line.setAttributeNS(null, "width", Double.valueOf(r.width).toString());
        line.setAttributeNS(null, "height", Double.valueOf(r.height).toString());
        svgRoot.appendChild(line);
    }
}

