/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.boxboard.models;

import java.util.Vector;
import org.apache.batik.swing.JSVGCanvas;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import ru.infor.boxboard.models.DrawBoxParam;
import ru.infor.navy.util.ElementCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DrawBox {
    static String clBlue = "#0000ff";
    static String clGreen = "#00ff00";
    static String clRed = "#ff0000";
    static String clMagenta = "#FF0080";
    String name;
    double width;
    double height;
    double offset = 50.0;
    public Document doc = null;
    public Vector<DrawBoxParam> parameters = new Vector();
    ElementCollector elemCollector = new ElementCollector();

    public String getName() {
        return this.name;
    }

    public void setWidth(double width) {
        this.width = width + this.offset;
    }

    public void setHeight(double height) {
        this.height = height + this.offset;
    }

    public abstract void draw();

    public abstract Vector<DrawBoxParam> getParams();

    public void clear() {
        this.elemCollector.clear();
    }

    public double translate(double coord) {
        return coord * 2.83 + this.offset;
    }

    public void repaint(JSVGCanvas canvas) {
    }

    public Element drawLine(Document doc, double x, double y, double xe, double ye, String color) {
        return this.elemCollector.add(doc, this.createD(x, y, xe, ye), color, "");
    }

    public void drawDashedLine(Document doc, double x, double y, double xe, double ye, String color, int dasharray) {
        this.elemCollector.add(doc, this.createD(x, y, xe, ye), color, Integer.valueOf(dasharray).toString());
    }

    private String createD(double x, double y, double xe, double ye) {
        StringBuffer sb = new StringBuffer("M");
        sb.append(this.translate(x));
        sb.append(",");
        sb.append(this.translate(y));
        sb.append("L");
        sb.append(this.translate(xe));
        sb.append(",");
        sb.append(this.translate(ye));
        return sb.toString();
    }

    public Element drawText(Document doc, double x, double y, String text, int size, String color) {
        Element svgRoot = doc.getDocumentElement();
        String svgNS = "http://www.w3.org/2000/svg";
        Element line = doc.createElementNS(svgNS, "text");
        line.setAttributeNS(null, "x", Double.valueOf(x).toString());
        line.setAttributeNS(null, "y", Double.valueOf(y).toString());
        line.setAttributeNS(null, "font-family", "Verdana");
        line.setAttributeNS(null, "font-size", Integer.valueOf(size).toString());
        line.setAttributeNS(null, "fill", "black");
        Text txt = doc.createTextNode(text);
        line.appendChild(txt);
        svgRoot.appendChild(line);
        return line;
    }

    public void drawCurveC(Document doc, double x, double y, double xe, double ye, double xc, double yc, double xce, double yce, String color) {
        StringBuffer sb = this.CreateC(x, y, xe, ye, xc, yc, xce, yce);
        this.elemCollector.add(doc, sb.toString(), color, "");
    }

    public void drawDashedCurveC(Document doc, double x, double y, double xe, double ye, double xc, double yc, double xce, double yce, String color, int dash) {
        StringBuffer sb = this.CreateC(x, y, xe, ye, xc, yc, xce, yce);
        this.elemCollector.add(doc, sb.toString(), color, Integer.valueOf(dash).toString());
    }

    private StringBuffer CreateC(double x, double y, double xe, double ye, double xc, double yc, double xce, double yce) {
        StringBuffer sb = new StringBuffer("M");
        sb.append(this.translate(x));
        sb.append(",");
        sb.append(this.translate(y));
        sb.append("C");
        sb.append(this.translate(xc));
        sb.append(",");
        sb.append(this.translate(yc));
        sb.append(",");
        sb.append(this.translate(xce));
        sb.append(",");
        sb.append(this.translate(yce));
        sb.append(",");
        sb.append(this.translate(xe));
        sb.append(",");
        sb.append(this.translate(ye));
        return sb;
    }
}

