/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.boxboard.models;

import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawBoxParam {
    public static final int DOUBLE = 0;
    public static final int INTEGER = 1;
    public static final int LIST = 2;
    public String name;
    private double value;
    public int index;
    public Vector<DrawBoxParam> listValues = null;
    public Vector<Integer> indexClearParameters = null;
    Vector<DrawBoxParam> parameters = null;
    public int type;

    public DrawBoxParam(String name) {
        this.name = name;
        this.value = 0.0;
        this.type = 0;
    }

    public DrawBoxParam(String name, double value, Vector<DrawBoxParam> parameters) {
        this.parameters = parameters;
        this.name = name;
        this.value = value;
        this.type = 0;
    }

    public DrawBoxParam(String name, int value, Vector<DrawBoxParam> parameters) {
        this.parameters = parameters;
        this.name = name;
        this.value = value;
        this.type = 1;
    }

    public DrawBoxParam(String name, DrawBoxParam dbp, Vector<DrawBoxParam> parameters) {
        this.parameters = parameters;
        this.name = name;
        this.type = 2;
        this.index = 0;
        this.listValues = new Vector();
        this.listValues.add(dbp);
    }

    public void addParameterForClear(int index) {
        if (this.indexClearParameters == null) {
            this.indexClearParameters = new Vector();
        }
        this.indexClearParameters.add(index);
    }

    public void setValue(double value) {
        this.setValue(value, true);
    }

    public void clear() {
        if (this.indexClearParameters == null) {
            return;
        }
        for (Integer i : this.indexClearParameters) {
            this.parameters.elementAt(i).setValue(-1.0, false);
        }
    }

    public void setValue(double value, boolean clear) {
        this.value = value;
        if (clear) {
            this.clear();
        }
    }

    public double getValue() {
        return this.value;
    }

    public void setSelectedValue(int index) {
        this.value = this.listValues.elementAt((int)index).value;
        this.index = index;
    }

    public void setSelectedValue(String name) {
        int index = -1;
        int i = 0;
        while (i < this.listValues.size()) {
            if (name.compareTo(this.listValues.elementAt((int)i).name) == 0) {
                index = i;
                break;
            }
            ++i;
        }
        if (index > -1) {
            this.setSelectedValue(index);
        }
    }

    public void addParam(DrawBoxParam dbp) {
        this.listValues.add(dbp);
    }
}

