/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.boxboard.print;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.image.ImageObserver;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.ImageIcon;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;

public class PrintModel
implements Printable,
ImageObserver {
    private JSVGCanvas canvas;
    Dimension2D d;
    PNGTranscoder trans = new PNGTranscoder();
    Image im = null;

    public PrintModel(JSVGCanvas canvas) {
        this.canvas = canvas;
        this.d = canvas.getSVGDocumentSize();
    }

    public int print(Graphics gr, PageFormat pageFormat, int pageIndex) throws PrinterException {
        int x = (int)pageFormat.getImageableX();
        int y = (int)pageFormat.getImageableY();
        gr.translate(x, y);
        int wPage = (int)pageFormat.getImageableWidth();
        int hPage = (int)pageFormat.getImageableHeight();
        int xCount = (int)Math.round(this.d.getWidth() / (double)wPage);
        int yCount = (int)Math.round(this.d.getHeight() / (double)hPage);
        if ((double)(xCount * wPage) < this.d.getWidth()) {
            ++xCount;
        }
        if ((double)(yCount * hPage) < this.d.getHeight()) {
            ++yCount;
        }
        if (pageIndex > yCount * xCount) {
            return 1;
        }
        Rectangle aoi = new Rectangle(wPage * (pageIndex - pageIndex / xCount * xCount), hPage * (pageIndex / xCount), wPage, hPage);
        this.trans.addTranscodingHint(PNGTranscoder.KEY_WIDTH, new Float(aoi.width));
        this.trans.addTranscodingHint(PNGTranscoder.KEY_HEIGHT, new Float(aoi.height));
        this.trans.addTranscodingHint(PNGTranscoder.KEY_AOI, aoi);
        TranscoderInput input = new TranscoderInput(this.canvas.getSVGDocument());
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            TranscoderOutput output = new TranscoderOutput(baos);
            this.trans.transcode(input, output);
            baos.flush();
            ImageIcon image = new ImageIcon(baos.toByteArray());
            gr.drawImage(image.getImage(), 0, 0, this);
            baos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (TranscoderException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    private void printPart(Graphics graphics, String outputFilename, int x, int y, int width, int height) {
        Rectangle aoi = new Rectangle(x, y, width, height);
        this.trans.addTranscodingHint(PNGTranscoder.KEY_WIDTH, new Float(aoi.width));
        this.trans.addTranscodingHint(PNGTranscoder.KEY_HEIGHT, new Float(aoi.height));
        this.trans.addTranscodingHint(PNGTranscoder.KEY_AOI, aoi);
        TranscoderInput input = new TranscoderInput(this.canvas.getSVGDocument());
        try {
            FileOutputStream ostream = new FileOutputStream(outputFilename);
            TranscoderOutput output = new TranscoderOutput(ostream);
            this.trans.transcode(input, output);
            ostream.flush();
            ((OutputStream)ostream).close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (TranscoderException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return true;
    }
}

