/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.navy.util;

import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.infor.navy.util.ElementInfo;

public class ElementCollector {
    Vector<ElementInfo> elements = new Vector();

    public Element add(Document doc, String d, String color, String dash) {
        ElementInfo res = this.find(color, dash);
        if (res == null) {
            Element svgRoot = doc.getDocumentElement();
            String svgNS = "http://www.w3.org/2000/svg";
            Element el = doc.createElementNS(svgNS, "path");
            el.setAttributeNS(null, "fill", "none");
            el.setAttributeNS(null, "stroke", color);
            el.setAttributeNS(null, "stroke-width", "1");
            if (dash.compareTo("") != 0) {
                el.setAttributeNS(null, "stroke-dasharray", dash);
            }
            el.setAttributeNS(null, "d", d);
            svgRoot.appendChild(el);
            res = new ElementInfo(color, dash, el);
            this.elements.add(res);
        } else {
            res.addPath(d);
        }
        return res.el;
    }

    public ElementInfo find(String color, String dash) {
        ElementInfo res = null;
        for (ElementInfo ei : this.elements) {
            if (ei.color.compareTo(color) != 0 || ei.dash.compareTo(dash) != 0) continue;
            res = ei;
            break;
        }
        return res;
    }

    public void clear() {
        this.elements.removeAllElements();
    }
}

