/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.navy.util;

import java.util.Vector;
import org.apache.batik.swing.JSVGCanvas;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGPathElement;
import ru.infor.navy.util.LengthInfo;

public class LengthCollector {
    public Vector<LengthInfo> elements = new Vector();
    public double totalLength = 0.0;

    public LengthCollector(Document doc) {
        this.totalLength = this.calcTotalLength(doc);
    }

    public double calcTotalLength(Document doc) {
        double length = 0.0;
        NodeList nl = doc.getElementsByTagName("path");
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i) instanceof SVGElement) {
                SVGPathElement svg = (SVGPathElement)nl.item(i);
                try {
                    double ttl = (double)svg.getTotalLength() / 2.83;
                    length += ttl;
                    this.add(svg.getAttribute("stroke"), ttl);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            ++i;
        }
        return length;
    }

    public LengthInfo getLengthInfoByColor(String color) {
        LengthInfo res = null;
        int i = 0;
        while (i < this.elements.size()) {
            LengthInfo li = this.elements.elementAt(i);
            if (li.color.compareTo(color) == 0) {
                res = li;
                break;
            }
            ++i;
        }
        return res;
    }

    public void add(String color, double length) {
        LengthInfo li = this.getLengthInfoByColor(color);
        if (li == null) {
            li = new LengthInfo(color);
            this.elements.addElement(li);
        }
        li.add(length);
    }

    public double getTotalLength() {
        double res = 0.0;
        int i = 0;
        while (i < this.elements.size()) {
            LengthInfo li = this.elements.elementAt(i);
            res += li.totalLength();
            ++i;
        }
        return res;
    }

    public Element drawText(Document doc, SVGElement parentEl, double x, double y, String text, int size, String color) {
        Element svgRoot = doc.getDocumentElement();
        String svgNS = "http://www.w3.org/2000/svg";
        Element line = doc.createElementNS(svgNS, "text");
        line.setAttributeNS(null, "transform", "matrix(1 0 0 1 " + Double.valueOf(x).toString() + " " + Double.valueOf(y).toString() + ")");
        Element tspan = doc.createElementNS(svgNS, "tspan");
        tspan.setAttributeNS(null, "x", "0");
        tspan.setAttributeNS(null, "y", "0");
        tspan.setAttributeNS(null, "font-family", "Verdana");
        tspan.setAttributeNS(null, "font-size", Integer.valueOf(size).toString());
        tspan.setAttributeNS(null, "fill", "black");
        Text txt = doc.createTextNode(text);
        tspan.appendChild(txt);
        line.appendChild(tspan);
        parentEl.appendChild(line);
        return line;
    }

    public Element drawRect(Document doc, SVGElement parentEl, double x, double y, double size, String color) {
        String svgNS = "http://www.w3.org/2000/svg";
        Element rect = doc.createElementNS(svgNS, "rect");
        rect.setAttributeNS(null, "x", Double.valueOf(x).toString());
        rect.setAttributeNS(null, "y", Double.valueOf(y).toString());
        rect.setAttributeNS(null, "width", Double.valueOf(size).toString());
        rect.setAttributeNS(null, "height", Double.valueOf(size).toString());
        rect.setAttributeNS(null, "fill", color);
        parentEl.appendChild(rect);
        return rect;
    }

    public SVGElement drawInfo(JSVGCanvas canvas, double x, double y) {
        Element svgRoot = canvas.getSVGDocument().getDocumentElement();
        String svgNS = "http://www.w3.org/2000/svg";
        SVGElement g = (SVGElement)canvas.getSVGDocument().createElementNS(svgNS, "g");
        g.setAttributeNS(null, "id", "Length");
        int rectSize = 8;
        int i = 0;
        while (i < this.elements.size()) {
            LengthInfo li = this.elements.elementAt(i);
            this.drawRect(canvas.getSVGDocument(), g, x + 22.0, y - 8.0, rectSize, li.color);
            this.drawText(canvas.getSVGDocument(), g, x + 22.0 + (double)rectSize + 3.0, y, String.valueOf(String.format("%8.2f", li.totalLength())) + " mm", 10, "black");
            y += 10.0;
            ++i;
        }
        this.drawText(canvas.getSVGDocument(), g, x, y + 3.0, "Total: " + String.format("%8.2f", this.getTotalLength()) + " mm", 10, "black");
        svgRoot.appendChild(g);
        return g;
    }

    public void testPrint() {
        String len;
        int i = 0;
        while (i < this.elements.size()) {
            LengthInfo li = this.elements.elementAt(i);
            len = String.format("%8.2f", li.totalLength());
            System.out.println(String.valueOf(li.color) + ": " + len);
            ++i;
        }
        len = String.format("%8.2f", this.getTotalLength());
        System.out.println("Total: " + len);
    }
}

