/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.navy.util;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGElement;

public class SVGTools {
    public static void cloneElement(Document doc, Element src, Element dst) {
        NodeList nl = src.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i) instanceof SVGElement) {
                Element els = (Element)nl.item(i);
                Element elt = doc.createElementNS("http://www.w3.org/2000/svg", els.getTagName());
                SVGTools.copyAttr(els, elt);
                dst.appendChild(elt);
                SVGTools.cloneElement(doc, els, elt);
            }
            ++i;
        }
    }

    public static void copyAttr(Element els, Element elt) {
        NamedNodeMap nmp = els.getAttributes();
        int i = 0;
        while (i < nmp.getLength()) {
            Node nn = nmp.item(i);
            elt.setAttributeNS(null, nn.getNodeName(), nn.getNodeValue());
            ++i;
        }
    }

    public static void removeElement(Element el) {
        NodeList nl = el.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i) instanceof SVGElement) {
                Element elem = (Element)nl.item(i);
                SVGTools.removeElement(elem);
            }
            ++i;
        }
        el.getParentNode().removeChild(el);
    }

    public static Element createRect(Document doc, double x, double y, double width, double height, String fillColor, String strokeColor, double strokeWidth, int opacity, String addStyle) {
        Element rect = doc.createElementNS("http://www.w3.org/2000/svg", "rect");
        rect.setAttributeNS(null, "x", Double.valueOf(x).toString());
        rect.setAttributeNS(null, "y", Double.valueOf(y).toString());
        rect.setAttributeNS(null, "width", Double.valueOf(width).toString());
        rect.setAttributeNS(null, "height", Double.valueOf(height).toString());
        rect.setAttributeNS(null, "style", "fill:" + fillColor + "; opacity:" + Integer.valueOf(opacity).toString() + "; stroke:" + strokeColor + "; stroke-width: " + Double.valueOf(strokeWidth).toString() + " " + addStyle);
        return rect;
    }

    public static Element createPath(Document doc, String d, String strokeColor, String fillColor, double strokeWidth, int opacity, String addStyle) {
        Element path = doc.createElementNS("http://www.w3.org/2000/svg", "path");
        path.setAttributeNS(null, "d", d);
        path.setAttributeNS(null, "style", "fill: " + fillColor + "; opacity:" + Integer.valueOf(opacity).toString() + "; stroke:" + strokeColor + "; stroke-width: " + Double.valueOf(strokeWidth).toString() + " " + addStyle);
        return path;
    }

    public static Element createLine(Document doc, double x, double y, double xe, double ye, String strokeColor, double strokeWidth, int opacity, String addStyle) {
        Element line = doc.createElementNS("http://www.w3.org/2000/svg", "line");
        line.setAttributeNS(null, "x1", Double.valueOf(x).toString());
        line.setAttributeNS(null, "y1", Double.valueOf(y).toString());
        line.setAttributeNS(null, "x2", Double.valueOf(xe).toString());
        line.setAttributeNS(null, "y2", Double.valueOf(ye).toString());
        line.setAttributeNS(null, "style", "fill:none; opacity:" + Integer.valueOf(opacity).toString() + "; stroke:" + strokeColor + "; stroke-width: " + Double.valueOf(strokeWidth).toString() + " " + addStyle);
        return line;
    }

    public static Element createGroup(Document doc, String id, String style) {
        Element g = doc.createElementNS("http://www.w3.org/2000/svg", "g");
        if (id.compareTo("") != 0) {
            g.setAttributeNS(null, "id", id);
        }
        if (style.compareTo("") != 0) {
            g.setAttributeNS(null, "style", style);
        }
        return g;
    }

    public static Element createImage(Document doc, String imageName) {
        Element image = doc.createElementNS("http://www.w3.org/2000/svg", "image");
        image.setAttributeNS(null, "xlink:href", imageName);
        image.setAttributeNS(null, "image-rendering", "optimizeSpeed");
        image.setAttributeNS(null, "width", "600");
        image.setAttributeNS(null, "height", "600");
        return image;
    }
}

