/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.navy.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Stack;
import java.util.Vector;

public class myXML
implements Serializable {
    private final boolean debug = false;
    private final String XMLheader = "<?xml version=\"1.0\"  encoding=\"UTF-8\" standalone=\"yes\"?>";
    private final String XMLcomment = "";
    private String tag;
    private Object element = null;
    public Attribute Attribute = new Attribute();
    private static final int TEXT = 1;
    private static final int ENTITY = 2;
    private static final int OPEN_TAG = 3;
    private static final int CLOSE_TAG = 4;
    private static final int START_TAG = 5;
    private static final int ATTRIBUTE_LVALUE = 6;
    private static final int ATTRIBUTE_EQUAL = 9;
    private static final int ATTRIBUTE_RVALUE = 10;
    private static final int QUOTE = 7;
    private static final int IN_TAG = 8;
    private static final int SINGLE_TAG = 12;
    private static final int COMMENT = 13;
    private static final int DONE = 11;
    private static final int DOCTYPE = 14;
    private static final int PRE = 15;
    private static final int CDATA = 16;
    private int line = 1;
    private int col = 0;
    private boolean eol = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public myXML(String tag) {
        this.tag = tag;
    }

    public myXML() {
    }

    public String getTag() {
        return this.tag;
    }

    public String getValue() {
        if (this.element == null) {
            return null;
        }
        if (this.element.getClass() == Vector.class) {
            return null;
        }
        return (String)this.element;
    }

    public int size() {
        if (this.element == null) {
            return 0;
        }
        if (this.element.getClass() == Vector.class) {
            return ((Vector)this.element).size();
        }
        return 0;
    }

    public myXML findElement(String tag) {
        if (this.tag.compareTo(tag) == 0) {
            return this;
        }
        if (this.element == null) {
            return null;
        }
        if (this.element.getClass() != Vector.class) {
            return null;
        }
        myXML xml = null;
        Vector v = (Vector)this.element;
        int i = 0;
        while (i < v.size()) {
            xml = (myXML)v.get(i);
            if (xml != null && xml.findElement(tag) != null) {
                return xml;
            }
            ++i;
        }
        return null;
    }

    public boolean removeElement(myXML element) throws myXMLException {
        if (element == null) {
            throw new myXMLException("Cannot prune if target element is null");
        }
        if (this.element == null) {
            throw new myXMLException("No subelements");
        }
        if (this.element.getClass() != Vector.class) {
            throw new myXMLException("No subelements");
        }
        Vector v = (Vector)this.element;
        if (v.size() <= 0) {
            return false;
        }
        if (!v.remove(element)) {
            return false;
        }
        if (v.size() == 0) {
            this.element = null;
        }
        return true;
    }

    public boolean contains(myXML element) throws myXMLException {
        if (element == null) {
            throw new myXMLException("Cannot prune if target element is null");
        }
        if (this.element == null) {
            throw new myXMLException("No subelements");
        }
        if (this.element.getClass() != Vector.class) {
            throw new myXMLException("No subelements");
        }
        Vector v = (Vector)this.element;
        if (v.size() <= 0) {
            return false;
        }
        return v.contains(element);
    }

    public boolean removeAllElements() {
        if (this.element == null) {
            return false;
        }
        if (this.element.getClass() != Vector.class) {
            return false;
        }
        this.element = null;
        return true;
    }

    public boolean isEmpty() {
        return this.element == null;
    }

    public myXML findattribute(String name) {
        if (this.Attribute.find(name) != null) {
            return this;
        }
        if (this.element == null) {
            return null;
        }
        if (this.element.getClass() != Vector.class) {
            return null;
        }
        myXML xml = null;
        Vector v = (Vector)this.element;
        int i = 0;
        while (i < v.size()) {
            xml = (myXML)v.get(i);
            if (xml.findattribute(name) != null) {
                return xml;
            }
            ++i;
        }
        return null;
    }

    public myXML findElement(String tag, String attname) {
        if (this.tag.compareTo(tag) == 0 && this.Attribute.find(attname) != null) {
            return this;
        }
        if (this.element == null) {
            return null;
        }
        if (this.element.getClass() != Vector.class) {
            return null;
        }
        myXML xml = null;
        Vector v = (Vector)this.element;
        int i = 0;
        while (i < v.size()) {
            xml = (myXML)v.get(i);
            if (xml.findElement(tag) != null && xml.Attribute.find(attname) != null) {
                return xml;
            }
            ++i;
        }
        return null;
    }

    public myXML getElement(int index) {
        if (this.element == null) {
            return null;
        }
        if (this.element.getClass() != Vector.class) {
            return null;
        }
        Vector v = (Vector)this.element;
        if (index > v.size()) {
            return null;
        }
        if (index < 0) {
            return null;
        }
        return (myXML)v.get(index);
    }

    private void setTag(String tag) {
        this.tag = tag;
    }

    private void setValue(String value) throws myXMLException {
        if (this.element != null && this.element.getClass() == Vector.class) {
            throw new myXMLException("Cannot assign a value to an element with subelements");
        }
        this.element = value;
    }

    public myXML addElement(String tag) throws myXMLException {
        Vector v = null;
        if (this.element != null && this.element.getClass() != Vector.class) {
            throw new myXMLException("Cannot create a subelement to an element with a value");
        }
        if (this.element == null) {
            v = new Vector();
            this.element = v;
        } else {
            v = (Vector)this.element;
        }
        myXML xml = new myXML(tag);
        v.add(xml);
        return xml;
    }

    public myXML addElement(String tag, Object value) throws myXMLException {
        Vector v = null;
        if (this.element != null && this.element.getClass() != Vector.class) {
            throw new myXMLException("Cannot create a subelement to an element with a value");
        }
        if (this.element == null) {
            v = new Vector();
            this.element = v;
        } else {
            v = (Vector)this.element;
        }
        myXML e = new myXML(tag);
        e.setValue(value.toString());
        v.add(e);
        return e;
    }

    public void serialize(PrintWriter out) throws IOException {
        boolean depth = false;
        out.println("<?xml version=\"1.0\"  encoding=\"UTF-8\" standalone=\"yes\"?>");
        out.println("");
        this.dumpelements("", out);
    }

    private void dumpelements(String indent, PrintWriter out) {
        out.print(String.valueOf(indent) + "<" + this.tag + this.Attribute.dumpattributes());
        if (this.element == null) {
            out.println("/>");
            return;
        }
        if (this.element.getClass() == Vector.class) {
            Vector v = (Vector)this.element;
            out.println(">");
            int i = 0;
            while (i < v.size()) {
                ((myXML)v.get(i)).dumpelements(new String(String.valueOf(indent) + "  "), out);
                ++i;
            }
            out.println(String.valueOf(indent) + "</" + this.tag + ">");
        } else {
            out.println(">" + this.getValue() + "</" + this.tag + ">");
        }
    }

    private Object cleanup(Object o) {
        if (o.getClass() == String.class) {
            String s = (String)o;
            s = s.replaceAll("&", "&amp;");
            s = s.replaceAll("<", "&lt;");
            s = s.replaceAll(">", "&gt;");
            s = s.replaceAll("\"", "&quot;");
            s = s.replaceAll("'", "&apos;");
            s = s.replaceAll("/", "&#47;");
            s = s.replaceAll("!", "&#33;");
            return s;
        }
        return o;
    }

    public myXML(BufferedReader in) throws myXMLException, myXMLEncodingException, IOException {
        myFileReader f = new myFileReader(in);
        try {
            this.readXML(this, f);
        }
        catch (myXMLEncodingException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (myXMLException e) {
            throw e;
        }
    }

    private static int popState(Stack st) {
        if (!st.empty()) {
            return (Integer)st.pop();
        }
        return 15;
    }

    private boolean checkforlinefeed(int c) {
        if (c == 10 && this.eol) {
            this.eol = false;
            return true;
        }
        if (this.eol) {
            this.eol = false;
        } else if (c == 10) {
            ++this.line;
            this.col = 0;
        } else if (c == 13) {
            this.eol = true;
            c = 10;
            ++this.line;
            this.col = 0;
        } else {
            ++this.col;
        }
        return false;
    }

    private void readXML(myXML xml, myFileReader in) throws myXMLException, myXMLEncodingException, IOException {
        int c;
        int state = 15;
        Stack<Integer> stack = new Stack<Integer>();
        StringBuffer sb = new StringBuffer();
        StringBuffer etag = new StringBuffer();
        String lvalue = null;
        String rvalue = null;
        int quotec = 34;
        block20: while ((c = in.read()) != -1) {
            if (this.checkforlinefeed(c)) continue;
            switch (state) {
                case 15: {
                    if (c != 60) continue block20;
                    stack.push(new Integer(1));
                    state = 5;
                    break;
                }
                case 5: {
                    state = myXML.popState(stack);
                    if (c == 47) {
                        stack.push(new Integer(state));
                        state = 4;
                        break;
                    }
                    if (c == 63) {
                        state = 14;
                        break;
                    }
                    if (xml.getTag() != null) {
                        in.unread(c);
                        in.unread(60);
                        this.readXML(xml.addElement(null), in);
                        state = myXML.popState(stack);
                        break;
                    }
                    stack.push(new Integer(state));
                    state = 3;
                    sb.append((char)c);
                    break;
                }
                case 3: {
                    if (c == 62) {
                        if (xml.getTag() == null) {
                            xml.setTag(sb.toString());
                        } else {
                            xml.addElement(sb.toString());
                        }
                        sb.setLength(0);
                        state = myXML.popState(stack);
                        break;
                    }
                    if (c == 47) {
                        state = 12;
                        break;
                    }
                    if (c == 45 && sb.toString().equals("!-")) {
                        state = 13;
                        break;
                    }
                    if (c == 91 && sb.toString().equals("![CDATA")) {
                        state = 16;
                        sb.setLength(0);
                        break;
                    }
                    if (c == 69 && sb.toString().equals("!DOCTYP")) {
                        sb.setLength(0);
                        state = 14;
                        break;
                    }
                    if (Character.isWhitespace((char)c)) {
                        xml.setTag(sb.toString());
                        sb.setLength(0);
                        state = 8;
                        break;
                    }
                    sb.append((char)c);
                    break;
                }
                case 1: {
                    if (Character.isWhitespace((char)c) && sb.length() < 1) continue block20;
                    if (c == 60) {
                        stack.push(new Integer(state));
                        state = 5;
                        if (sb.length() <= 0) continue block20;
                        xml.setValue(sb.toString());
                        sb.setLength(0);
                        break;
                    }
                    if (c == 38) {
                        stack.push(new Integer(state));
                        state = 2;
                        etag.setLength(0);
                        break;
                    }
                    sb.append((char)c);
                    break;
                }
                case 4: {
                    if (c == 62) {
                        state = myXML.popState(stack);
                        String endTag = sb.toString();
                        if (endTag.compareTo(xml.getTag()) != 0) {
                            throw new myXMLEncodingException("Mismatched close tag near line " + this.line + ", column " + this.col);
                        }
                        sb.setLength(0);
                        return;
                    }
                    sb.append((char)c);
                    break;
                }
                case 8: {
                    if (c == 62) {
                        state = myXML.popState(stack);
                        break;
                    }
                    if (c == 47) {
                        state = 12;
                        break;
                    }
                    if (Character.isWhitespace((char)c)) continue block20;
                    state = 6;
                    sb.append((char)c);
                    break;
                }
                case 11: {
                    return;
                }
                case 16: {
                    if (c == 62 && sb.toString().endsWith("]]")) {
                        sb.setLength(sb.length() - 2);
                        xml.setValue(sb.toString());
                        sb.setLength(0);
                        state = myXML.popState(stack);
                        break;
                    }
                    sb.append((char)c);
                    break;
                }
                case 13: {
                    if (c == 62 && sb.toString().endsWith("--")) {
                        sb.setLength(0);
                        state = myXML.popState(stack);
                        break;
                    }
                    sb.append((char)c);
                    break;
                }
                case 14: {
                    if (c != 62 || (state = myXML.popState(stack)) != 1) continue block20;
                    state = 15;
                    break;
                }
                case 2: {
                    if (c == 59) {
                        state = myXML.popState(stack);
                        String cent = etag.toString();
                        etag.setLength(0);
                        if (cent.equals("lt")) {
                            sb.append('<');
                            break;
                        }
                        if (cent.equals("gt")) {
                            sb.append('>');
                            break;
                        }
                        if (cent.equals("amp")) {
                            sb.append('&');
                            break;
                        }
                        if (cent.equals("quot")) {
                            sb.append('\"');
                            break;
                        }
                        if (cent.equals("apos")) {
                            sb.append('\'');
                            break;
                        }
                        if (cent.startsWith("#")) {
                            sb.append((char)Integer.parseInt(cent.substring(1)));
                            break;
                        }
                        throw new myXMLEncodingException("Unknown entity: &" + cent + "; near line " + this.line + ", column " + this.col);
                    }
                    etag.append((char)c);
                    break;
                }
                case 12: {
                    if (xml.getTag() == null) {
                        xml.setTag(sb.toString());
                        sb.setLength(0);
                    }
                    if (c != 62) {
                        throw new myXMLEncodingException("Expected > for tag <" + xml.getTag() + "/> near line " + this.line + ", column " + this.col);
                    }
                    return;
                }
                case 7: {
                    if (c == quotec) {
                        rvalue = sb.toString();
                        sb.setLength(0);
                        xml.Attribute.add(lvalue, rvalue);
                        state = 8;
                        break;
                    }
                    if (" \r\n\t".indexOf(c) >= 0) {
                        sb.append(' ');
                        break;
                    }
                    if (c == 38) {
                        stack.push(new Integer(state));
                        state = 2;
                        etag.setLength(0);
                        break;
                    }
                    sb.append((char)c);
                    break;
                }
                case 10: {
                    if (c == 34 || c == 39) {
                        quotec = c;
                        state = 7;
                        break;
                    }
                    if (Character.isWhitespace((char)c)) continue block20;
                    throw new myXMLEncodingException("Error in attribute processing near line " + this.line + ", column " + this.col);
                }
                case 6: {
                    if (Character.isWhitespace((char)c)) {
                        lvalue = sb.toString();
                        sb.setLength(0);
                        state = 9;
                        break;
                    }
                    if (c == 61) {
                        lvalue = sb.toString();
                        sb.setLength(0);
                        state = 10;
                        break;
                    }
                    sb.append((char)c);
                    break;
                }
                case 9: {
                    if (c == 61) {
                        state = 10;
                        break;
                    }
                    if (Character.isWhitespace((char)c)) continue block20;
                    throw new myXMLEncodingException("Error in attribute processing near line " + this.line + ", column " + this.col);
                }
                default: {
                    throw new myXMLEncodingException("State exception near line " + this.line + ", column " + this.col);
                }
            }
        }
        if (state == 11) {
            return;
        }
        throw new myXMLEncodingException("Missing end tag near line " + this.line + ", column " + this.col);
    }

    public class Attribute {
        private Vector attributes = new Vector();

        public void add(String name, Object value) {
            attribute a = new attribute(name, value.toString());
            this.attributes.add(a);
        }

        private String dumpattributes() {
            String result = new String("");
            int i = 0;
            while (i < this.attributes.size()) {
                attribute o = (attribute)this.attributes.get(i);
                result = new String(String.valueOf(result) + " " + o.name + "=\"" + myXML.this.cleanup(o.value) + "\"");
                ++i;
            }
            return result;
        }

        public String find(String name) {
            if (this.attributes.size() == 0) {
                return null;
            }
            int i = 0;
            while (i < this.attributes.size()) {
                attribute a = (attribute)this.attributes.get(i);
                if (a.name != null && a.name.compareTo(name) == 0) {
                    return a.value;
                }
                ++i;
            }
            return null;
        }

        private class attribute {
            public String name = null;
            public String value = null;

            attribute(String name, String value) {
                this.name = name;
                this.value = value;
            }
        }
    }

    private class myFileReader
    implements Serializable {
        Stack stack = new Stack();
        BufferedReader f = null;

        myFileReader(BufferedReader in) {
            this.f = in;
        }

        void unread(int c) {
            this.stack.push(new Integer(c));
        }

        int read() throws IOException {
            if (this.stack.empty()) {
                return this.f.read();
            }
            int c = (Integer)this.stack.pop();
            return c;
        }
    }

    public static class myXMLEncodingException
    extends Exception
    implements Serializable {
        public myXMLEncodingException() {
        }

        public myXMLEncodingException(String s) {
            super(s);
        }
    }

    public static class myXMLException
    extends Exception
    implements Serializable {
        public myXMLException() {
        }

        public myXMLException(String s) {
            super(s);
        }
    }

    public static class myXMLIOException
    extends Exception
    implements Serializable {
        public myXMLIOException() {
        }

        public myXMLIOException(String s) {
            super(s);
        }
    }
}

